<?php

/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/

	class AppController extends Controller {
		public $view   = 'Theme';
		public $theme = 'default';
		
		var $uses = array('Setting');
		var $components = array('Auth','Email','Session','SeoUrl','Cookie','RequestHandler');
		var $helpers = array('Paginator','Session','Image');
		
		function beforeFilter(){											
			//reads the site-wide config values from the DB and puts them through the Configure::write method
			
			$this->Setting->getcfg();
			$this->Auth->logoutRedirect = array('controller' => 'videos','action' => 'index','home');
			$this->Auth->loginRedirect = array('controller' => 'videos', 'action' => 'index','home');
			$this->Auth->loginAction = array('controller' => 'users', 'action' => 'login');
			$this->Auth->fields = array('username' => 'email', 'password' => 'password');
			if (isset($this->params['requested'])) $this->Auth->allow($this->action); 			
			$this->Auth->deny('edit','changepassword','change-password');
			$this->Auth->allow('*');
			$this->Auth->authorize = 'controller';
			$this->Auth->userScope = array('User.account_status' => 'active','User.email_status' => 'active');
			$this->set('loggedIn', $this->Auth->user('id'));
			$this->set('groupId', $this->Auth->user('group_id'));
			
			$this->Cookie->name = 'tube-script-agriz';
			$this->Cookie->path = '/';
			$this->Cookie->name = 'qSI231qs*&sXOw!';
			$this->disableCache(); 
			
			
			/* admin related */
			if(isset($this->params['admin']) && $this->params['admin']) {  
				// check user is logged in  
				if( $this->Auth->user('group_id') != 2 ) {
					$this->Session->setFlash('You must be logged in for that action.','flash_bad');  
					$this->redirect('/login');  
				}  
  
				// save user data  
				$admin_user = $this->Session->read('admin_user');  
				$this->set('adm_user',$admin_user);
	  
				// change layout  
				$this->layout = 'admin'; 				
			}
			
			App::import('Core','L10n');
			$l10n =& new L10n();
			
			//Language params set?
			$lang = 'eng';
			
			$l10n->get($lang);
		}
		
		function isAuthorized() {
			return true;
		}
		
	}